

export class ContractTaskPopup {
	
	tpl = `
		<div class="contract-task-popup">
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0)" [onclick]="widget.close" class="fa fa-times-circle"></a>
				
				<span ez-if="task.contractTaskId > 0 && writable">
					<a href="javascript:void(0);" [onclick]="widget.deleteTask" class="fa fa-trash"></a>
				</span>
				
				<a ez-if="writable" href="javascript:void(0);" [onclick]="widget.saveTask" class="fa fa-save"></a>
			</div>

			<h1>
				{{ task.contractTaskId ? 'Taak bewerken' : 'Nieuwe taak' }}
				
				<span ez-if="contract.contractId">
					- {{ contract.name }}
				</span>
			</h1>
		</div>
		
		<div ez-if="showGotoContract == true">
			<div class="action-box">
				<span><a href="javascript:void(0);" [onclick]="widget.gotoContract">Open Contract</a></span>
			</div>
			<hr/>
		</div>
		
			<fieldset>
				<legend>Planning</legend>
				<form id="frmContractTask" action="{{appUrl('/service/contracts/task.do')}}">
				
					<ez-checkbox label="Actief" name="active" [checked]="task.active"></ez-checkbox>	
				
					<ez-text label="Omschrijving" name="description" [value]="task.description"></ez-text>
								
					<ez-select label="Periode" name="noticeMoment" [value]="task.noticeMoment">
						<option value="on_date">Op datum</option>
						<option value="since_date_recurrent">Terugkerend vanaf</option>
						<option value="before_start">Voor start contract</option>
						<option value="after_start">Na start contract</option>
						<option value="before_renewal">Voor verlenging contract</option>
						<option value="after_renewal">Na verlenging contract</option>
						<option value="before_end">Voor einddatum contract</option>
						<option value="after_end">Na einddatum contract</option>
						<option value="change_status">Wijziging status</option>
					</ez-select>
					
					<ez-date label="Datum" name="taskDate" [value]="task.taskDate"></ez-date>
					
					<div class="time-notice-container">
						<ez-number min="0" name="timeNotice" label="Termijn" [value]="task.timeNotice"></ez-number>
						<ez-select name="timeNoticeUnit" label="" [value]="task.timeNoticeUnit">
							<option value="day">Dag</option>
							<option value="week">Week</option>
							<option value="month">Maand</option>
							<option value="year">Jaar</option>
						</ez-select>
					</div>
					
					<div class="task-status-moment">
						<ez-checkbox name="csOpen"        [checked]="task.csOpen"        label="Open"></ez-checkbox>
						<ez-checkbox name="csNegotiation" [checked]="task.csNegotiation" label="In onderhandeling"></ez-checkbox>
						<ez-checkbox name="csReviewal"    [checked]="task.csReviewal"    label="Ter beoordeling"></ez-checkbox>
						<ez-checkbox name="csAccepted"    [checked]="task.csAccepted"    label="Geaccepteerd"></ez-checkbox>
						<ez-checkbox name="csActive"      [checked]="task.csActive"      label="Actief"></ez-checkbox>
						<ez-checkbox name="csExpiring"    [checked]="task.csExpiring"    label="Aflopend"></ez-checkbox>
						<ez-checkbox name="csTerminated"  [checked]="task.csTerminated"  label="Beeindigd"></ez-checkbox>
						
					</div>
					
					<ez-textarea label="Notitie" name="note" [value]="task.note"></ez-textarea>
				</form>
			</fieldset>
		
			<fieldset style="margin-top: 25px;">
				<legend>Taken</legend>
				
				<span ez-if="!task.events || task.events.length == 0" style="font-style: italic;">
					Taken worden automatisch aangemaakt na het opslaan en bij opvolgende momenten
				</span>
				
				<div class="contract-task-events" ez-if="task.events && task.events.length > 0">
					<table class="table">
						<thead>
							<tr>
								<th>Opmerking</th>
								<th>Alert datum</th>
								<th>Status</th>
							</tr>
						</thead>
						<tbody ez-for="task.events" ez-item="tevt">
							<tr data-contract-task-event-id="{{ tevt.contractTaskEventId }}">
								<td class="td-task-event-note">
									<input type="text" class="tevt-note" name="" [value]="tevt.note" />
								</td>
								<td>
									{{ format_date( new Date(tevt.taskDate), {dmy: true} ) }}
								</td>
								<td>
									<select class="tevt-status">
										<option value="open" [selected]="{{ tevt.status=='open' }}">Open</option>
										<option value="inprogress" [selected]="{{ tevt.status=='inprogress' }}">In behandeling</option>
										<option value="done" [selected]="{{ tevt.status=='done' }}">Voltooid</option>
									</select>
								</td>
							</tr>
						</tbody>
					</table>
					
				</div>
			</fieldset>
		</div>
	`;
	
	writable = true;
	container = null;
	loading = false;
	
	contractTaskId = null;
	
	ezTpl = null;
	task = {
		active: true,
		contractId: '',
		noticeMoment: '',
		timeNotice: '',
		timeNoticeUnit: 'month',
		name: '',
		description: '',
		taskDate: '',
		
		csOpen:        true,
		csNegotiation: true,
		csReviewal:    true,
		csAccepted:    true,
		csActive:      true,
		csExpiring:    true,
		csTerminated:  true
	};
	
	contract = {};
	
	callback_close = null;
	callback_save = null;
	
	showGotoContract = false;
	
	
	constructor(contractTaskId) {
		if (contractTaskId)
			this.loadTask( contractTaskId );
	}
	
	
	init(e) {
		this.container = e;
		
//		if (id) {
//			this.loadTask( id );
//		}
//		else {
			this.render();
//		}
	}
	
	setContractId( id ) { this.task.contractId = id; }
	
	setCallbackClose( c ) { this.callback_close = c; }
	setCallbackSave( c ) { this.callback_save = c; }
	
	setShowGotoContract( bln ) {
		this.showGotoContract = bln ? true : false;
	}
	gotoContract() {
		gotoRoute( '/contracts/edit/?id='+this.task.contractId );
	}
	
	render() {
//		console.log( this.tpl );
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setVar('writable', this.writable);
		this.ezTpl.setVar('task', this.task);
		this.ezTpl.setVar('contract', this.contract);
		this.ezTpl.setVar('showGotoContract', this.showGotoContract);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.render();
		
		focusFirstField('#frmContractTask');
		
		$('.contract-task-popup #frmContractTask select[name=noticeMoment]').on('change', function() {
			this.noticeMomentChange();
		}.bind(this));
		this.noticeMomentChange();

		
		if (this.writable == false) {
			$(this.container).find('input, select, textarea').attr('readonly', 'readonly');
			$(this.container).find('input[type=checkbox], select').attr('disabled', 'disabled');
		}		

				
		$('.contract-task-popup .contract-task-events').find('.tevt-note').on('change', function( evt ) {
			let ctid = $(evt.currentTarget).closest('tr').data('contract-task-event-id');
			this.updateTaskEvent( ctid );
		}.bind(this));
		
		$('.contract-task-popup .contract-task-events').find('.tevt-status').on('change', function( evt ) {
			let ctid = $(evt.currentTarget).closest('tr').data('contract-task-event-id');
			this.updateTaskEvent( ctid );
		}.bind(this));
	}
	
	
	
	updateTaskEvent( contractTaskEventId ) {
		let tr = $('.contract-task-popup [data-contract-task-event-id=' + contractTaskEventId + ']');
		
		let note = $(tr).find('.tevt-note').val();
		let status = $(tr).find('.tevt-status').val();
		

		postUrl( '/service/contracts/task.do', {
			a: 'updateTaskEvent',
			contractTaskEventId: contractTaskEventId,
			note: note,
			status: status
		}).then( async function(e) {
//			let json = await e.json();
			showToastMessage( 'Wijziging opgeslagen' );
		}.bind(this));
	}
	
	
	
	saveTask() {
		if (this.loading) {
			return;
		}
		console.log('saveTask');
		
		this.loading = true;
		
		let frm = $('.contract-task-popup #frmContractTask');
		
		this.task.active         = frm.find('input[name=active]').prop('checked') ? 1 : 0;
		this.task.description    = frm.find('input[name=description]').val();
		this.task.status         = frm.find('select[name=status]').val();
		this.task.noticeMoment   = frm.find('select[name=noticeMoment]').val();
		this.task.taskDate       = frm.find('input[name=taskDate]').val();
		this.task.timeNotice     = frm.find('input[name=timeNotice]').val();
		this.task.timeNoticeUnit = frm.find('select[name=timeNoticeUnit]').val();
		this.task.note           = frm.find('textarea[name=note]').val();
		
		this.task.csOpen        = frm.find('input[name=csOpen]').prop('checked')        ? 1 : 0;
		this.task.csNegotiation = frm.find('input[name=csNegotiation]').prop('checked') ? 1 : 0;
		this.task.csReviewal    = frm.find('input[name=csReviewal]').prop('checked')    ? 1 : 0;
		this.task.csAccepted    = frm.find('input[name=csAccepted]').prop('checked')    ? 1 : 0;
		this.task.csActive      = frm.find('input[name=csActive]').prop('checked')      ? 1 : 0;
		this.task.csExpiring    = frm.find('input[name=csExpiring]').prop('checked')    ? 1 : 0;
		this.task.csTerminated  = frm.find('input[name=csTerminated]').prop('checked')  ? 1 : 0;
		
		
		let data = this.task;
		data.a = 'save';
		
		console.log( data );
		
		showLoadingForm('#frmContractTask');
		
		postJson( '/service/contracts/task.do', data )
		.then(async function(e) {
			let json = await e.json();
			this.loading = false;
			hideLoadingForm('#frmContractTask');
			
			if (json.error) {
				formShowErrors( '#frmContractTask', json );
			}
			else {
				if (this.callback_save != null) {
					this.callback_save( this.task );
				}
				
				close_popup();
			}
			
		}.bind(this));
	}
	
	
	deleteTask() {
		
		showConfirmation('Verwijderen', 'Weet je zeker dat je deze taak wilt verwijderen?', function() {
			postUrl( '/service/contracts/task.do', {
				a: 'deleteTask',
				contractTaskId: this.task.contractTaskId
			}).then( async function(e) {
				if (this.callback_save != null) {
					this.callback_save( this.task );
				}
				
				close_popup();
			}.bind(this));
		}.bind(this));
		
	}
	
	
	
	noticeMomentChange() {
		let frm = $('#frmContractTask');
		
		let nm = frm.find('select[name=noticeMoment]').val();
		
		$(this.container).find('.task-status-moment').hide();
		
		if (nm == 'on_date') {
			frm.find('ez-date[name=taskDate]').show();
			frm.find('.time-notice-container').hide();
		}
		else if (nm == 'since_date_recurrent') {
			frm.find('ez-date[name=taskDate]').show();
			frm.find('.time-notice-container').show();
		}
		else if (nm == 'change_status') {
			frm.find('ez-date[name=taskDate]').hide();
			frm.find('.time-notice-container').hide();
			$(this.container).find('.task-status-moment').show();
		}
		else {
			frm.find('ez-date[name=taskDate]').hide();
			frm.find('.time-notice-container').show();
		}
		
	}
	
	
	close() {
		close_popup();
	}
	
	showPopup() {
		this.container = show_popup('Taak', '');
		
		this.container.get(0).close_callback = function() {
			if (this.callback_close != null) {
				this.callback_close( this.task );
			}
		}.bind(this);
		
		this.render();
		
		return this.container;
	}
	
	loadTask(contractTaskId) {
		postUrl( '/service/contracts/task.do', {
				a: 'view',
				contractTaskId: contractTaskId
		}).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget(json);
			}
			
			this.writable = json.writable;
			this.task = json.contractTask;
			this.contract = json.contract;
			this.render();
			
			this.loading = false;
		}.bind(this) );
	}
	
}


